﻿# Optimal aPLib compressor
by Eugene Larchenko

- [Download executable for Windows x64](bin/x64/oapack.exe)

*aPLib* is data compression format developed by [Jørgen Ibsen](http://ibsensoftware.com/products_aPLib.html). 

This project contains specific compressor implementation. It achieves maximum compression possible for aPLib compression scheme. It does exhaustive search, trying all possible combinations using dynamic programming. For this reason, the compressor is slow and has the following **limitations**:

*  input file size is limited to 65536 bytes;
*  file must not contain long repetitive runs; processing these is extremely slow; use fast mode (see below);
*  severe amounts of memory -- up to 9\**N*<sup>2</sup> bytes -- required; for this reason 64-bit mode is recommended.

The implementation is straightforward and doesn't involve complex data structures. The resulting algorithm complexity is *O*(*n*<sup>3</sup>), which seems insane, but in most practical cases it finishes in reasonable time span.

Faster suboptimal compression can be enabled with *-f* option. Algorithm complexity is *O*(*n*<sup>2</sup>).

This compressor produces raw compressed stream, no headers, no decompressor included.

Supports back-to-front compression (*-b* option).

### Other compressors

* [aplib_pack2 by r57shell](http://gendev.spritesmind.net/forum/viewtopic.php?f=7&t=703&&start=45#p32548)
* [apc12spke](https://www.cpcwiki.eu/forum/programming/quick-update-on-the-state-of-the-art-compression-using-aplib/msg177112/#msg177112)
* [apultra](https://github.com/emmanuel-marty/apultra)
* [cap](https://github.com/svendahl/cap)

### Discussion boards

* [zx-pk.ru](https://zx-pk.ru/threads/23155-szhatie-i-upakovka-obsuzhdenie-i-sravneniya.html?p=1061809&viewfull=1#post1061809) (rus)
* [CPCWiki](https://www.cpcwiki.eu/forum/programming/quick-update-on-the-state-of-the-art-compression-using-aplib/) (eng)
* [pouet.net](https://www.pouet.net/prod.php?which=85851) (eng)
