/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.Fixed;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;

public class TableDirectory {
    private int _version = 0;
    private short _numTables = 0;
    private short _searchRange = 0;
    private short _entrySelector = 0;
    private short _rangeShift = 0;
    private final DirectoryEntry[] _entries;

    public TableDirectory(DataInput dataInput) throws IOException {
        this._version = dataInput.readInt();
        this._numTables = dataInput.readShort();
        this._searchRange = dataInput.readShort();
        this._entrySelector = dataInput.readShort();
        this._rangeShift = dataInput.readShort();
        this._entries = new DirectoryEntry[this._numTables];
        for (int i = 0; i < this._numTables; ++i) {
            this._entries[i] = new DirectoryEntry(dataInput);
        }
    }

    public DirectoryEntry getEntry(int n) {
        return this._entries[n];
    }

    public DirectoryEntry getEntryByTag(int n) {
        for (int i = 0; i < this._numTables; ++i) {
            if (this._entries[i].getTag() != n) continue;
            return this._entries[i];
        }
        return null;
    }

    public short getEntrySelector() {
        return this._entrySelector;
    }

    public short getNumTables() {
        return this._numTables;
    }

    public short getRangeShift() {
        return this._rangeShift;
    }

    public short getSearchRange() {
        return this._searchRange;
    }

    public int getVersion() {
        return this._version;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Offset Table\n------ -----").append("\n  sfnt version:     ").append(Fixed.floatValue(this._version)).append("\n  numTables =       ").append(this._numTables).append("\n  searchRange =     ").append(this._searchRange).append("\n  entrySelector =   ").append(this._entrySelector).append("\n  rangeShift =      ").append(this._rangeShift).append("\n\n");
        for (int i = 0; i < this._numTables; ++i) {
            stringBuilder.append(i).append(". ").append(this._entries[i].toString()).append("\n");
        }
        return stringBuilder.toString();
    }
}

