#include "stdafx.h"

#include <windows.h>
#include <stdlib.h>


#define SADR(x) ((x-16384+27))


void wordwr(unsigned char *data,int val)
{
	*data++=(val>>8)&0xff;
	*data++=(val&0xff);
}



int main(int argc,char* argv[])
{
	char name[MAX_PATH];
	unsigned char *ay;
	unsigned char *sna;
	FILE *file;
	int size;
	int i;

	if(argc<2)
	{
		printf("MBTESNAY (Music Box T.E. SNA to AY) by Shiru, 09'09\n");
		printf("USAGE: mbtesnay.exe filename.sna\n");
		return 0;
	}

	file=fopen(argv[1],"rb");
	if(!file)
	{
		printf("Can't open file\n");
		return 0;
	}

	fseek(file,0,SEEK_END);
	size=ftell(file);
	fseek(file,0,SEEK_SET);

	if(size!=131103&&size!=147487)
	{
		fclose(file);
		printf("Wrong SNA file size\n");
		return 0;
	}

	sna=(unsigned char*)malloc(size);
	fread(sna,size,1,file);
	fclose(file);

	ay=(unsigned char*)malloc(65536);

	memcpy(ay,"ZXAYEMUL",8);
	ay[8]=1;//file version
	ay[9]=3;//player version (3 for 48K support)
	ay[10]=0;//special player, short int
	ay[11]=0;
	wordwr(&ay[12],58-12);//author offset
	wordwr(&ay[14],91-14);//misc offset
	ay[16]=0;//number of songs in file-1
	ay[17]=0;//first song-1
	wordwr(&ay[18],2);//end struct offset
	wordwr(&ay[20],91-20);//NTStr offset
	wordwr(&ay[22],2);//song header offset
	ay[24]=0;//AY A
	ay[25]=1;//AY B
	ay[26]=2;//AY C
	ay[27]=3;//AY Noise
	wordwr(&ay[28],0);//song length (0 for unknown)
	wordwr(&ay[30],0);//fade length
	ay[32]=0;//hireg
	ay[33]=0;//loreg
	wordwr(&ay[34],4);//points offset
	wordwr(&ay[36],8);//data offset
	wordwr(&ay[38],0x8000);//stack
	wordwr(&ay[40],0xc00c);//init
	wordwr(&ay[42],0x0038);//interrupt
	wordwr(&ay[44],0xa000);//addr of block in Z80
	wordwr(&ay[46],2000);//length of block
	wordwr(&ay[48],129-48);//offset to block
	wordwr(&ay[50],0xc000);//addr of block in Z80
	wordwr(&ay[52],512);//length of block
	wordwr(&ay[54],2129-54);//offset to block
	wordwr(&ay[56],0);//end of blocks list
	memcpy(&ay[58],&sna[SADR(0xa000+2004)],32);
	for(i=58;i<58+32;i++) if(ay[i]<32||ay[i]>127) ay[i]=32;
	ay[90]=0;
	memcpy(&ay[91],"Exported from Music Box T.E. (Beeper)",37);
	ay[128]=0;
	sna[SADR(0xa000+999)]=64;
	sna[SADR(0xa000+1999)]=64;
	sna[SADR(0xc010)]=0xc3;
	sna[SADR(0xc011)]=0x0d;
	sna[SADR(0xc012)]=0xc0;
	sna[SADR(0xc000+35)]=sna[SADR(0xa000)]-3;
	i=0xa000;
	sna[SADR(0xc000+27)]=i&0xff;
	sna[SADR(0xc000+28)]=(i>>8)&0xff;
	i=0xa000+1000;
	sna[SADR(0xc000+31)]=i&0xff;
	sna[SADR(0xc000+32)]=(i>>8)&0xff;
	i=0xa000+sna[SADR(0xa000+2000)]+(sna[SADR(0xa000+2001)]<<8);
	sna[SADR(0xc000+29)]=i&0xff;
	sna[SADR(0xc000+30)]=(i>>8)&0xff;
	i=0xa000+sna[SADR(0xa000+2002)]+(sna[SADR(0xa000+2003)]<<8);
	sna[SADR(0xc000+33)]=i&0xff;
	sna[SADR(0xc000+34)]=(i>>8)&0xff;
	memcpy(&ay[129],&sna[SADR(0xa000)],2000);
	memcpy(&ay[2129],&sna[SADR(0xc000)],512);

	strcpy(name,argv[1]);
	name[strlen(name)-3]='a';
	name[strlen(name)-2]='y';
	name[strlen(name)-1]=0;
	file=fopen(name,"wb");

	if(!file)
	{
		printf("Can't create file\n");
	}
	else
	{
		fwrite(ay,2641,1,file);
		fclose(file);
	}

	free(ay);
	free(sna);

	return 0;
}