;Music Box T.E. v1.2
;by Shiru (shiru@mail.ru) 09'09

;  SjAsmPlus

    device zxspectrum48

    org #6500

MAXROWS equ 999     ;  
PAGEROW equ 16      ;  
PLAYER  equ #c000   ;  

begin
    jp $+6
    jp editorStart

    ld (.tempSP),sp

    di
    ld sp,begin-1
    im 1
    ei
 
    ld hl,playerData
    ld de,PLAYER
    ld bc,512
    ldir
 
    call makeFont
    call makeScrTable
    call makeNoteNames
    call tuneClear

    call cls
    ld hl,#0508
    ld bc,#1670
    call setAttr
    inc h
    inc h
    ld bc,strTitle0
    call strOut
    ld hl,#060a
    ld bc,strTitle1
    call strOut
    ld hl,#0210
    ld bc,strTitle2
    call strOut
    ld hl,#0211
    ld bc,strTitle3
    call strOut
    ld hl,#0212
    ld bc,strTitle4
    call strOut
 
    call waitKey

    ld a,0          ; 
    ld (PLAYER+26),a

.tempSP=$+1
    ld sp,0
    ret

editorStart
    ld a,(tuneData)
    ld (tempo),a

    call cls
    ld hl,#1204
    ld bc,strOctave
    call strOut
    ld hl,#1005
    ld bc,strAutoStep
    call strOut
    ld hl,#1306
    ld bc,strTempo
    call strOut
    ld hl,#1009
    ld bc,strNoise
    call strOut
    ld hl,#100a
    ld bc,strNoiseD
    call strOut
    ld hl,#100b
    ld bc,strNoiseW
    call strOut
    ld hl,#1017
    ld bc,strInfo
    call strOut
    ld hl,#0f0e
    ld bc,strLoop0
    call strOut
    ld hl,#0f0f
    ld bc,strLoop1
    call strOut
    ld hl,#1011
    ld bc,strCopyLen
    call strOut
    ld hl,#0f12
    ld bc,strPasteLen
    call strOut
 
editorLoop

    ld hl,#1a04
    ld a,(curOctave)
    call dec1NumOut
    ld hl,#1a05
    ld de,(autoStep)
    call dec2NumOut
    ld hl,#1a06
    ld a,(tempo)
    ld d,0
    ld e,a
    call dec3NumOut

    ld hl,#1d0a
    call scrPos
    ld a,(noiseD)
    ld c,a
    ld b,4
.loop0
    rr c
    ld a,'-'
    jr nc,$+4
    ld a,'#'
    call chrOutA
    dec l
    djnz .loop0

    ld hl,#1a0b
    ld a,(noiseW)
    ld d,0
    ld e,a
    call dec3NumOut
 
    ld hl,#1a0e
    ld de,(ch1Loop)
    call dec3NumOut
    ld hl,#1a0f
    ld de,(ch2Loop)
    call dec3NumOut
 
    ld hl,#1a11
    ld de,(copyLen)
    call dec3NumOut
    ld hl,#1a12
    ld de,(copyBufLen)
    call dec3NumOut

viewPattern
    ld hl,(curRow)
    ld bc,12
    sbc hl,bc
    jr nc,$+5
    ld hl,0
    ld bc,MAXROWS-24
    ld a,h
    cp b
    jr c,.loop0
    ld a,l
    cp c
    jr c,.loop0
    ld h,b
    ld l,c
.loop0
    ld b,h
    ld c,l
    ld (attrCur.row),bc
    ld hl,#0100
    ld a,24
.loop1
    push hl
    push bc
    push af

    ld (.cur0),bc
    ld (.cur1),bc
 
    ld d,b
    ld e,c
    push hl
    call dec3NumOut
    pop hl
    ld h,6
    call scrPos

    push hl
.cur0=$+1
    ld hl,0
    ld bc,tuneData+1
    add hl,bc
    ld b,tagName/256
    ld c,(hl)
    pop hl
 
    ld a,(bc)
    inc b
    call chrOutA
    inc l
    ld a,(bc)
    inc b
    call chrOutA
    inc l
    ld a,(bc)
    call chrOutA
    inc l
    inc l
 
    push hl
.cur1=$+1
    ld hl,0
    ld bc,tuneData+1001
    add hl,bc
    ld b,tagName/256
    ld c,(hl)
    pop hl
 
    ld a,(bc)
    inc b
    call chrOutA
    inc l
    ld a,(bc)
    inc b
    call chrOutA
    inc l
    ld a,(bc)
    call chrOutA

    pop af
    pop bc
    pop hl
    inc l
    inc bc
    dec a
    jp nz,.loop1

attrCur
    ld hl,#5800
.row=$+1
    ld de,0
    ld a,24
.loop0
    push af
    push de
    push hl
    ld bc,(curRow)
    ld a,d
    cp b
    jr nz,.loop1
    ld a,e
    cp c
    jr nz,.loop1
    ld b,7+8
    jr .loop2
.loop1
    ld b,7
.loop2
    ld a,e
    and 3           ;  
    ld a,b
    jr nz,$+4
    or 64
    ld b,14
.loop3
    ld (hl),a
    inc l
    djnz .loop3
    pop hl
    push hl
    and 63
    cp 7+8
    jr nz,.loop4
    ld a,(curChn)   ;   
    ld c,6
    or a
    jr z,$+4
    ld c,10
    add hl,bc
    ld a,64+48
    dup 3
    ld (hl),a
    inc l
    edup
    org $-1
.loop4
    pop hl
    pop de
    pop af
    ld c,32
    add hl,bc
    inc de
    dec a
    jr nz,.loop0

pollKbd
    call waitKey

    cp 11           ;UP
    jr nz,.key0
    ld bc,1
    call moveCurUp
    jp .keyE
.key0
    cp 10           ;DOWN
    jr nz,.key1
    ld bc,1
    call moveCurDown
    jp .keyE
.key1
    cp 4            ;PAGEUP
    jr nz,.key2
    ld bc,PAGEROW
    call moveCurUp
    jp .keyE
.key2
    cp 5            ;PAGEDOWN
    jr nz,.key3
    ld bc,PAGEROW
    call moveCurDown
    jp .keyE
.key2.0
    ld hl,MAXROWS-1
    ld (curRow),hl
    jp .keyE
.key3
    cp 8            ;LEFT
    jr nz,.key4
    ld a,0
    ld (curChn),a
    jp .keyE
.key4
    cp 9            ;RIGHT
    jr nz,.key5
    ld a,1
    ld (curChn),a
    jp .keyE
.key5
    cp 33           ;  1
    jr nz,.key6
    ld a,1
    ld (curOctave),a
    jp .keyE
.key6
    cp 64           ;  2
    jr nz,.key7
    ld a,2
    ld (curOctave),a
    jp .keyE
.key7
    cp 35           ;  3
    jr nz,.key8
    ld a,3
    ld (curOctave),a
    jp .keyE
.key8
    cp 36           ;  4
    jr nz,.key9
    ld a,4
    ld (curOctave),a
    jp .keyE
.key9
    cp 'z'          ; 
    jr nz,.key10
    ld a,0
    jp .setNote
.key10
    cp 's'          ; #
    jr nz,.key11
    ld a,1
    jp .setNote
.key11
    cp 'x'          ; 
    jr nz,.key12
    ld a,2
    jp .setNote
.key12
    cp 'd'          ; #
    jr nz,.key13
    ld a,3
    jp .setNote
.key13
    cp 'c'          ; 
    jr nz,.key14
    ld a,4
    jp .setNote
.key14
    cp 'v'          ; 
    jr nz,.key15
    ld a,5
    jp .setNote
.key15
    cp 'g'          ; #
    jr nz,.key16
    ld a,6
    jp .setNote
.key16
    cp 'b'          ; 
    jr nz,.key17
    ld a,7
    jp .setNote
.key17
    cp 'h'          ; #
    jr nz,.key18
    ld a,8
    jp .setNote
.key18
    cp 'n'          ; 
    jr nz,.key19
    ld a,9
    jp .setNote
.key19
    cp 'j'          ; #
    jr nz,.key20
    ld a,10
    jp .setNote
.key20
    cp 'm'          ; 
    jr nz,.key21
    ld a,11
    jp .setNote
.setNote
    push af
    call getNoteAdr
    ld a,(curOctave)
    ld b,a
    pop af
    sub 12
    add a,12
    djnz $-2
    cp 48
    jr c,$+4
    ld a,47
    add a,244
    ld (hl),a
    call playNote
    ld bc,(autoStep)
    call moveCurDown
    jp .keyE
.key21
    cp 12           ;   
    jr nz,.key22
    call rowDelete
    jp .keyE
.key22
    cp 13           ;   
    jr nz,.key23
    call playFromCur
    jp .keyE
.key23
    cp 'l'          ; 
    jr nz,.key24
    call getNoteAdr
    ld (hl),64
    jp .keyE
.key24
    cp 37           ; autostep
    jr nz,.key25
    ld hl,(autoStep)
    ld bc,1
    sbc hl,bc
    jp c,.keyE
    ld (autoStep),hl
    jp .keyE
.key25
    cp 38           ; autostep
    jr nz,.key26
    ld hl,(autoStep)
    ld a,l
    inc a
    cp 100
    jp nc,.keyE
    ld l,a
    ld (autoStep),hl
    jp .keyE
.key26
    cp 39           ; tempo
    jr nz,.key27
    ld hl,tempo
    ld a,(hl)
    dec a
    cp 231
    jp c,.keyE
    ld (hl),a
    ld (tuneData),a
    jp .keyE
.key27
    cp 40           ; tempo
    jr nz,.key28
    ld hl,tempo
    ld a,(hl)
    inc a
    cp 255
    jp nc,.keyE
    ld (hl),a
    ld (tuneData),a
    jp .keyE
.key28
    cp 199          ;HOME
    jr nz,.key29
    ld hl,0
    ld (curRow),hl
    jp .keyE
.key29
    cp 200          ;END
    jr nz,.key30
    call moveCurLoop
    jp .keyE
.key30
    cp 201          ;INSERT
    jr nz,.key31
    call rowInsert
    jp .keyE
.key31
    cp 15           ;DELETE
    jr nz,.key32
    call getNoteAdr
    ld (hl),41
    ld bc,(autoStep)
    call moveCurDown
    jp .keyE
.key32
    cp 32           ;MENU
    jr nz,.key33
    jp menuStart
.key33
    cp 'a'          ;
    jr nz,.key34
    call getNoteAdr
    ld (hl),#b4
    call playNote
    ld bc,(autoStep)
    call moveCurDown
    jp .keyE
.key34
    cp 226          ;   0
    jr nz,.key35
    ld hl,noiseD
    ld a,(hl)
    xor 8
    ld (hl),a
    jp .keyE
.key35
    cp 195          ;   1
    jr nz,.key36
    ld hl,noiseD
    ld a,(hl)
    xor 4
    ld (hl),a
    jp .keyE
.key36
    cp 205          ;   2
    jr nz,.key37
    ld hl,noiseD
    ld a,(hl)
    xor 2
    ld (hl),a
    jp .keyE
.key37
    cp 204          ;   3
    jr nz,.key38
    ld hl,noiseD
    ld a,(hl)
    xor 1
    ld (hl),a
    jp .keyE
.key38
    cp 62           ;  
    jr nz,.key39
    ld hl,noiseW
    ld a,(hl)
    cp 1
    jp z,.keyE
    dec a
    ld (hl),a
    jp .keyE
.key39
    cp 198          ;  
    jr nz,.key40
    ld hl,noiseW
    ld a,(hl)
    inc a
    jp z,.keyE
    ld (hl),a
    jp .keyE
.key40
    cp 'f'          ; 
    jr nz,.key41
    call getNoteCh0
    ld a,(noiseD)
    and 15
    add a,#e4
    ld (hl),a
    ld de,1000
    add hl,de
    ld a,(noiseW)
    ld (hl),a
    call playNote
    ld bc,(autoStep)
    call moveCurDown
    jp .keyE
.key41
    cp 'k'          ;   
    jr nz,.key42
    call getNoteCh0
    ld a,(hl)
    cp 42
    jp c,.keyE
    cp 244
    jp nc,.keyE
    sub #e4
    and 15
    ld (noiseD),a
    ld de,1000
    add hl,de
    ld a,(hl)
    ld (noiseW),a
    jp .keyE
.key42
    cp 34           ;  
    jr nz,.key43
    ld bc,(curRow)
    ld a,(curChn)
    or a
    jr nz,.key42.0
    ld (ch1Loop),bc
    jp .keyE
.key42.0
    ld (ch2Loop),bc
    jp .keyE
.key43
    cp 197          ;  
    jr nz,.key44
    ld bc,(copyLen)
    dec bc
    ld a,b
    or c
    jp z,.keyE
    ld (copyLen),bc
    jp .keyE
.key44
    cp 172          ;  
    jr nz,.key45
    ld hl,MAXROWS-1
    ld de,(curRow)
    sbc hl,de
    ld bc,(copyLen)
    sbc hl,bc
    jp c,.keyE
    inc bc
    ld (copyLen),bc
    jp .keyE
.key45
    cp 'q'          ; 
    jr nz,.key46
    ld a,12
    jp .setNote
.key46
    cp '2'          ; #
    jr nz,.key47
    ld a,13
    jp .setNote
.key47
    cp 'w'          ; 
    jr nz,.key48
    ld a,14
    jp .setNote
.key48
    cp '3'          ; #
    jr nz,.key49
    ld a,15
    jp .setNote
.key49
    cp 'e'          ; 
    jr nz,.key50
    ld a,16
    jp .setNote
.key50
    cp 'r'          ; 
    jr nz,.key51
    ld a,17
    jp .setNote
.key51
    cp '5'          ; #
    jr nz,.key52
    ld a,18
    jp .setNote
.key52
    cp 't'          ; 
    jr nz,.key53
    ld a,19
    jp .setNote
.key53
    cp '6'          ; #
    jr nz,.key54
    ld a,20
    jp .setNote
.key54
    cp 'y'          ; 
    jr nz,.key55
    ld a,21
    jp .setNote
.key55
    cp '7'          ; #
    jr nz,.key56
    ld a,22
    jp .setNote
.key56
    cp 'u'          ; 
    jr nz,.key57
    ld a,23
    jp .setNote
.key57
.keyE
    jp editorLoop

; 

menuStart
    ld hl,#5800
    ld bc,#0300
.loop0
    ld a,(hl)
    and %00110000
    ld a,1
    jr z,$+4
    ld a,8
    ld (hl),a
    inc hl
    dec bc
    ld a,b
    or c
    jr nz,.loop0

    ld hl,#0017
    ld bc,#204f
    call setAttr
    ld bc,strMainMenu
    call strOut
    ld hl,#0117
    ld bc,#0170
    call setAttr
    ld h,#06
    call setAttr
    ld h,#0b
    call setAttr
    ld h,#11
    call setAttr
    ld h,#16
    call setAttr
    ld h,#1b
    call setAttr

.loop1
    call waitKey
 
    cp 'f'          ;FILE
    jr nz,.key0
    jp fileMenuStart
.key0
    cp 'c'          ;COPY
    jr nz,.key1
    call blockCopy
    jp editorStart
.key1
    cp 'p'          ;PASTE
    jr nz,.key2
    call blockPaste
    jp editorStart
.key2
    cp 'h'          ;HEAR
    jr nz,.key3
    call playFromStart
    jp editorStart
.key3
    cp 'n'          ;NAME
    jr nz,.key4
    ld hl,#0017
    ld bc,#2047
    call setAttr
    ld de,tuneData+2004
    ld b,32
    call strInput
    jp editorStart
.key4
    cp 'i'          ;INFO
    jr nz,.key5
    jp showHelp
.key5
    cp 32
    jr nz,.loop1
    jp editorStart

; 

fileMenuStart
    ld hl,#0017
    ld bc,#204f
    call setAttr
    ld bc,strFileMenu
    call strOut
    ld hl,#0117
    ld bc,#0170
    call setAttr
    ld h,#05
    call setAttr
    ld h,#0a
    call setAttr

.loop0
    call waitKey
 
    cp 'n'          ;NEW
    jr nz,.key0
    call confirmDialog
    or a
    call nz,tuneClear
    jp editorStart
.key0
    cp 'l'          ;LOAD
    jr nz,.key1
    call settingsClear
    ld bc,0
    ret
.key1
    cp 's'          ;SAVE
    jr nz,.key2
    ld bc,1
    ret
.key2
    cp 32
    jr nz,.loop0
    jp editorStart

;

confirmDialog
    ld hl,#0017
    ld bc,#2057
    call setAttr
    ld bc,strConfirm
    call strOut
    ld hl,#0717
    ld bc,#0170
    call setAttr
    inc h
    inc h
    call setAttr

.loop0
    call waitKey
    cp 'y'
    ret z
    cp 'n'
    ld a,0
    ret z
    jr .loop0

; 

showHelp
    xor a
    ld (.row),a
    call cls
    ld bc,strHelp
.loop0
    ld a,(bc)
    cp 255
    jr z,.loop4
    ld h,0
.row=$+1
    ld l,0
    ld (.pos),hl
    call scrPos
    ld e,0
.loop1
    ld a,(bc)
    inc bc
    push de
    push af
    call chrOutA
    pop af
    pop de
    inc l
    inc e
    cp ':'
    jr nz,.loop1
    push hl
    push bc
.pos=$+1
    ld hl,0
    ld b,e
    ld c,64+6
    call setAttr
    pop bc
    pop hl
.loop2
    ld a,(bc)
    inc bc
    cp 32
    jr c,.loop3
    call chrOutA
    inc l
    jr .loop2
.loop3
    ld hl,.row
    inc (hl)
    dec a
    jr nz,.loop3
    jr .loop0
.loop4
    call waitKey
    jp editorStart

;    

tuneClear
    ld hl,tuneData
    ld de,tuneData+1
    ld bc,1999
    ld (hl),41
    ldir
 
settingsClear
    ld bc,0
    ld (curRow),bc
    ld a,0
    ld (curChn),a
    ld a,2
    ld (curOctave),a
    ld bc,1
    ld (autoStep),bc
    ld a,235
    ld (tempo),a
    ld (tuneData),a
    ld a,15
    ld (noiseD),a
    ld a,1
    ld (noiseW),a
    ld bc,8
    ld (copyLen),bc
    ld bc,0
    ld (copyBufLen),bc
    ld (ch1Loop),bc
    ld (ch2Loop),bc
 
    ld hl,tuneData+2004
    ld de,tuneData+2005
    ld bc,#1f
    ld (hl),#20
    ldir
 
    ret

;   
;: HL=

getNoteCh0
    xor a
    jr $+5
getNoteAdr
    ld a,(curChn)
    or a
    ld hl,tuneData+1
    jr z,$+5
    ld hl,tuneData+1001
    ld bc,(curRow)
    add hl,bc
    ret

;   

blockCopy
    call getNoteAdr
    ld de,copyBuf
    ld bc,(copyLen)
    ld (copyBufLen),bc
    ldir
    ret

;   

blockPaste
    call getNoteAdr
    ld de,copyBuf
    ex de,hl
    ld bc,(copyBufLen)
    ld a,b
    or c
    ret z
    ldir
    ret

;    

rowInsert
    ld a,(curChn)
    or a
    ld hl,tuneData+1
    jr z,$+5
    ld hl,tuneData+1001
    push hl
    ld bc,MAXROWS-1
    add hl,bc
    ld bc,(curRow)
    push hl
    ld hl,MAXROWS
    sbc hl,bc
    ld b,h
    ld c,l
    pop hl
    ld d,h
    ld e,l
    dec hl
    lddr
    pop hl
    ld bc,(curRow)
    add hl,bc
    ld (hl),41
    ret

;   

rowDelete
    ld a,(curChn)
    or a
    ld hl,tuneData+1
    jr z,$+5
    ld hl,tuneData+1001
    push hl
    ld bc,(curRow)
    add hl,bc
    push hl
    ld hl,MAXROWS
    sbc hl,bc
    ld b,h
    ld c,l
    pop hl
    ld d,h
    ld e,l
    inc hl
    dec bc
    ldir
    pop hl
    ld bc,MAXROWS-1
    add hl,bc
    ld (hl),41
    ret

;  

playNote
    ld a,(tempo)
    ld (PLAYER+35),a
    ld hl,tuneData+1
    ld bc,(curRow)
    add hl,bc
    dec hl
    ld (PLAYER+27),hl
    ld hl,tuneData+1001
    ld bc,(curRow)
    add hl,bc
    dec hl
    ld (PLAYER+31),hl
    di
    call PLAYER+71
    ei
    xor a
    out (#fe),a
    ret

;      

playFromCur
    ld a,(tempo)
    ld (PLAYER+35),a
    ld hl,tuneData+1
    ld bc,(curRow)
    add hl,bc
    dec hl
    ld (PLAYER+27),hl
    ld hl,tuneData+1
    ld bc,(ch1Loop)
    add hl,bc
    ld a,(hl)
    cp 64
    ret z
    ld (PLAYER+29),hl
    ld hl,tuneData+1001
    ld bc,(curRow)
    add hl,bc
    dec hl
    ld (PLAYER+31),hl
    ld hl,tuneData+1001
    ld bc,(ch2Loop)
    add hl,bc
    ld a,(hl)
    cp 64
    ret z
    ld (PLAYER+33),hl
    call endPush
    di
.loop0
    call PLAYER+71
    call #028e
    inc e
    jr nz,.loop0
    ei
    xor a
    out (#fe),a
    call endPop
    ret

;      

playFromStart
    ld a,(tempo)
    ld (PLAYER+35),a
    ld hl,tuneData
    ld (PLAYER+27),hl
    inc hl
    ld bc,(ch1Loop)
    add hl,bc
    ld a,(hl)
    cp 64
    ret z
    ld (PLAYER+29),hl
    ld hl,tuneData+1000
    ld (PLAYER+31),hl
    inc hl
    ld bc,(ch2Loop)
    add hl,bc
    ld a,(hl)
    cp 64
    ret z
    ld (PLAYER+33),hl
    call endPush
    di
.loop0
    call PLAYER+71
    call #028e
    inc e
    jr z,.loop0
    ei
    xor a
    out (#fe),a
    call endPop
    ret

;         

endPush
    ld e,64
    ld hl,tuneData+999
    ld a,(hl)
    ld (endPop.ch1),a
    ld (hl),e
    ld hl,tuneData+1999
    ld a,(hl)
    ld (endPop.ch2),a
    ld (hl),e
    ret

;     

endPop
.ch1=$+1
    ld a,0
    ld (tuneData+999),a
.ch2=$+1
    ld a,0
    ld (tuneData+1999),a
    ret

;  
;: BC=  

moveCurUp
    ld hl,(curRow)
    sbc hl,bc
    jr nc,$+5
    ld hl,0
    ld (curRow),hl
    ret

;  
;: BC=  

moveCurDown
    ld hl,(curRow)
    add hl,bc
    ld bc,MAXROWS
    sbc hl,bc
    jr c,$+5
    ld hl,-1
    add hl,bc
    ld (curRow),hl
    ret

;     

moveCurLoop
    ld a,(curChn)
    or a
    ld hl,tuneData+1
    jr z,$+5
    ld hl,tuneData+1001
    ld bc,(curRow)
    add hl,bc
    ld de,MAXROWS
.loop0
    ld a,(hl)
    cp 64
    jr z,.loop1
    inc hl
    inc bc
    push hl
    ld h,b
    ld l,c
    sbc hl,de
    pop hl
    ret nc
    jr .loop0
.loop1
    ld (curRow),bc
    ret

; 
;: H=x,L=y,DE=,B=

strInput
    xor a
    ld (.cur),a
    ld (.off),de
.loop0
    push hl
    push de
    push bc
    ld c,#4f
    call setAttr
    push bc
    push hl
.cur=$+1
    ld a,0
    add a,h
    ld h,a
    ld bc,#0170
    call setAttr
    pop hl
    pop bc
    call scrPos
.off=$+1
    ld de,0
.loop1
    ld a,(de)
    inc de
    push de
    call chrOutA
    pop de
    inc l
    djnz .loop1
 
    call waitKey
    pop bc
    pop de
    pop hl
 
    cp 13           ;ENTER
    ret z
.key0
    cp 8            ;LEFT
    jr nz,.key1
.key0.0
    ld a,(.cur)
    or a
    jr z,.keyE
    dec a
    ld (.cur),a
    dec de
    jr .keyE
.key1
    cp 9            ;RIGHT
    jr nz,.key2
.key1.0
    ld a,(.cur)
    inc a
    cp b
    jr nc,.keyE
    ld (.cur),a
    inc de
    jr .keyE
.key2
    cp 12           ; 
    jr nz,.key3
    ld a,32
    ld (de),a
    jr .key0.0
.key3
    cp 32
    jr c,.keyE
    cp 128
    jr nc,.keyE
    ld (de),a
    jr .key1.0
.keyE
    jr .loop0

;  
;: H=x,L=y,C=,B=

setAttr
    push bc
    push de
    push hl
    ld e,h
    ld d,#58
    ld h,#00
    add hl,hl
    add hl,hl
    add hl,hl
    add hl,hl
    add hl,hl
    add hl,de
.loop0
    ld (hl),c
    inc hl
    djnz .loop0
    pop hl
    pop de
    pop bc
    ret

;   

cls
    xor a
    out (#fe),a
    ld h,#5b
.loop0
    dec hl
    ld (hl),a
    or (hl)
    jr z,.loop0

    ld h,#57
.loop1
    inc hl
    ld (hl),7+64
    bit 2,h
    jr z,.loop1
 
    ret

;    

makeFont
    ld hl,#3d00
    ld de,fontData+32
    ld b,96
.loop0
    push bc
    push de
    ld b,8
.loop1
    ld a,(hl)
    inc hl
    ld (de),a
    inc d
    djnz .loop1
    pop de
    pop bc
    inc e
    djnz .loop0

    ret

;   

makeScrTable
    ld hl,#4000
    ld de,scrTable
    ld b,24
.loop0
    ld a,l
    ld (de),a
    set 7,e
    ld a,h
    ld (de),a
    res 7,e
    inc e
    call downChr
    djnz .loop0

    ret

;  

makeNoteNames
    ld hl,tagName
    ld b,0
.loop0
    ld (hl),'N'
    inc h
    ld (hl),'S'
    inc h
    ld (hl),'E'
    dec h
    dec h
    inc l
    djnz .loop0
 
    push hl
    ld l,41
    ld a,'-'
    ld (hl),a
    inc h
    ld (hl),a
    inc h
    ld (hl),a
    pop hl

    push hl
    ld l,64
    ld (hl),'R'
    inc h
    ld (hl),'E'
    inc h
    ld (hl),'P'
    pop hl
 
    push hl
    ld l,#b4
    ld (hl),'T'
    inc h
    ld (hl),'O'
    inc h
    ld (hl),'M'
    pop hl

    ld c,'1'
    ld l,244
.loop1
    ld de,noteName
    ld b,12
.loop2
    ld a,(de)
    ld (hl),a
    inc h
    inc de
    ld a,(de)
    ld (hl),a
    inc h
    inc de
    ld (hl),c
    dec h
    dec h
    inc l
    djnz .loop2
    inc c
    ld a,c
    cp '5'
    jr nz,.loop1

    ret

;    
;: H=x,L=y
;: HL=

scrPos
    push af
    push de
    ld a,h
    ld h,scrTable/256
    ld e,(hl)
    set 7,l
    ld d,(hl)
    ld h,0
    ld l,a
    add hl,de
    pop de
    pop af
    ret

;   
;  DOWN_HL+ by Spencer Winsent

downChr
    ld a,l
    sub #e0
    ld l,a
    sbc a,a
    and #f8
    add a,h
    add a,8
    ld h,a
    ret

;  
;: HL=   , E= 

chrOutA
    ld e,a
chrOut
    ld d,fontData/256

    dup 8
    ld a,(de)
    ld (hl),a
    inc d
    inc h
    edup
    org $-2
    ld a,h
    sub 7
    ld h,a

    ret

;  
;: H=x,L=y, BC= 

strOut
    call scrPos
.loop0
    ld a,(bc)
    or a
    ret z
    call chrOutA
    inc l
    inc bc
    jr .loop0

;  ,    
;: H=x,L=y, DE=

dec3NumOut
    call scrPos
    ex de,hl
    ld a,'0'
    ld bc,100
.loop0
    scf
    ccf
    sbc hl,bc
    jr c,.loop1
    inc a
    jp .loop0
.loop1
    add hl,bc
    ex de,hl
    push de
    call chrOutA
    pop de
    inc l
    ex de,hl
    ld a,'0'
    ld bc,10
.loop2
    scf
    ccf
    sbc hl,bc
    jr c,.loop3
    inc a
    jp .loop2
.loop3
    add hl,bc
    ex de,hl
    push de
    call chrOutA
    pop de
    inc l
    ld a,e
    add a,'0'
    call chrOutA
    ret

;  ,    
;: H=x,L=y, E=

dec2NumOut
    ld d,0
    call scrPos
    ex de,hl
    ld a,'0'
    ld bc,10
.loop0
    scf
    ccf
    sbc hl,bc
    jr c,.loop1
    inc a
    jp .loop0
.loop1
    add hl,bc
    ex de,hl
    push de
    call chrOutA
    pop de
    inc l
    ld a,e
    add a,'0'
    call chrOutA
    ret

;  ,  
;: H=x,L=y, A=

dec1NumOut
    call scrPos
    add a,'0'
    call chrOutA
    ret

;  
;: A= 

waitKey
.loop0
    bit 5,(iy+1)
    jr z,.loop0
    ld a,(23560)
    res 5,(iy+1)
    ret

strTitle0   db "* MUSIC BOX T.E. *",0
strTitle1   db "v1.2 by  Shiru 09'09",0
strTitle2   db "Based on beeper music player",0
strTitle3   db "from the WHAM! The Music box",0
strTitle4   db 127,"1985 Mark Time Ltd",0
strOctave   db "Octave:",0
strAutoStep db "Autostep:",0
strTempo    db "Tempo:",0
strInfo     db "Space for menu",0
strMainMenu db " File Copy Paste Hear Name Info ",0
strFileMenu db " New Load Save                  ",0
strConfirm  db " Sure? Y/N                      ",0
strNoise    db "Noise effect",0
strNoiseD   db "Duration:",0
strNoiseW   db "Waveform:",0
strLoop0    db "Ch.1 loop:",0
strLoop1    db "Ch.2 loop:",0
strCopyLen  db "Copy len:",0
strPasteLen db "Paste len:",0
strHelp     db "CS+3,4,5,6,7,8: move cursor",1
            db "SS+Q: jump to start",1
            db "SS+E: jump to loop end",2
            db "SS+1,2,3,4: select octave",1
            db "SS+5,6: autostep",1
            db "SS+7,8: tempo",2
            db "Z,S,X,D,C,V,G,B,H,N,J,M: note",1
            db "Q,2,W,3,E,R,5,T,6,Y,7,U: note up",1
            db "CS/9: clear note",1
            db "CS/0: delete note",1
            db "SS+W: insert note",2
            db "A: set tone drum",1
            db "F: set noise drum",1
            db "K: get noise settings",1
            db "SS+A,S,D,F: noise duration",1
            db "SS+T,Y: noise waveform",2
            db "L,SS+P: set loop start and end",1
            db "ENTER: hold to play",2
            db "U,I: change copy block length",1
            db 255
noteName    db "C-C#D-D#E-F-F#G-G#A-A#B-"

playerData
    incbin "player.bin"
    org playerData+512

end

    display /d,$-begin

curRow      dw 0
curChn      db 0
curOctave   db 0
autoStep    dw 0
tempo       db 0
noiseD      db 0
noiseW      db 0
copyLen     dw 0
copyBufLen  dw 0
tuneData=#a000
ch1Loop=tuneData+2000
ch2Loop=tuneData+2002

    align 256
scrTable
    ds 256
fontData
    ds 8*256
tagName
    ds 3*256,'0'
copyBuf
    ds 1024
 
    display $
 
    ;savesna "main.sna",begin
    savebin "mboxte.bin",begin,end-begin