program tfmcom;

{$APPTYPE CONSOLE}

uses
  SysUtils;

(*
;%11111111,-disp8 = use old frame data
;%111ttttt = skip 32..2 frames
;%110ddddd = slide d+16
;%11010000,frames,-disp16 = repeat block (skips are used as 1 frame)
;%10111111,-disp16 = use old frame data
;%10NNNNNf = keyoff,[freq,]0..30 regs, keyon
;%01111111 = end
;%01111110 = begin
;%01NNNNNf = keyoff,[freq,]0..31 regs
;%00NNNNNf =        [freq,]0..30 regs
*)
//uses dos;
 const
  bufsz=2000;
  wrbufsz=2000;
  newaddrsz=1048576;
  maxskipframes=32{64} { 25   topgun.tfd,
                                64   uzhos.tfd,
                                97   cosmofm.tfd,
                                43   lam.tfd };
 var
// DirInfo:SearchRec;
 fin,fout:file;
 filename,loadfilename,savefilename:string;
 buf4:array[0..3]of char;
 tfmdinfosize:longint{integer};
 tfmd:boolean;
 kusok:array[0..bufsz-1]of byte;
 wrbuf:array[0..wrbufsz-1]of byte;
 chsize:array[0..11]of longint{integer};
 readpos,writepos,realbufsz,curframelength,disp,maxlen,maxframes,
  where,wherelength:longint{integer};
 i,j,j1,k,totalread,totalwrite,totaltotalwrite,
  chaddr,
  slideeconomy,lowfreqeconomy,notefreqskipeconomy,
   economy2,economy3,economy4:longint;
 bye:integer; {0=EOF}
 b:byte; (*   fin     fout*)
 inskipframes,outskipframes:longint;
 t,h,l,cmd,tempbyte:byte;
 frame,notes,keyons,keyoffs,keydups,keyofffreqs,dups,tls,
    noskips,
  freqs,fullfreqs,lowfreqs,slides{,
   ints,fds,fcs,intfds,
     maybes,
     ssgs,
      ssglfrqs,ssgslides,ssghfrqs,ssghfrq1s,
       ssgvols,ssgdupvols}:longint;
 chip:byte; (*  0/1*)
 ch,ch123,chchip:byte;
 high,lowh,keyh:array[0..1,0..2]of byte; (* *)
 ssgh:array[0..1,0..15]of byte;
 oldcmd,oldt:byte;
 nregs,howmanyinsregs,howmanyoldregs,howmanychangedregs:byte;
 oldh,oldl:integer{ byte,    };

 key,keyon,keyoff,keyonprepared,keyoffprepared,
  loopbeg,loopend:boolean;
 byteisread,found,dublicateframefound:boolean;
 reg,regprepared:array[0..1,0..255]of integer;
 regchanged,regtowrite:array[0..1,0..255]of boolean;
 indata:array[0..1048576]of byte;
 outdata:array[0..1048576]of byte;
 newaddr:array[0..newaddrsz-1]of longint{integer};
 regswritten,oldregswritten,
  maxregswritten,newmaxregswritten,
   regsmaybeshifted,regsmustbeshifted:longint{word};

function inttohex(b:byte):string;
var s:string;
const hexdig:array[0..15]of char=
('0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f');
begin
 s:=hexdig[b div 16]+hexdig[b mod 16];
 inttohex:=s;
end;

procedure bread;
begin
 if readpos>=realbufsz then begin
  if eof(fin)then begin
   inc(bye);   if(bye<>0)then writeln('read after eof!');
   readpos:=0;
   realbufsz:=0;
   kusok[readpos]:=$00;
  end
  else begin
   blockread(fin,kusok,bufsz,realbufsz);
   totalread:=totalread+realbufsz;
   readpos:=0;
  end;
 end;
 b:=kusok[readpos];
 inc(readpos);
end;

procedure bwrite;
begin
 if writepos>=wrbufsz then begin
  totalwrite:=totalwrite+wrbufsz;
  blockwrite(fout,wrbuf,wrbufsz);
  writepos:=0;
 end;
 wrbuf[writepos]:=b;
 inc(writepos);
end;

procedure arraywrite;
begin
 outdata[writepos]:=b;
 inc(writepos);
end;


procedure writeskipframes;
begin
 if outskipframes<=maxskipframes
 then begin
  b:=256-outskipframes;
  if b=$ff then b:=0;
  bwrite;
  outskipframes:=0;
 end
 else begin
  b:=256-maxskipframes;
  bwrite;
  outskipframes:=outskipframes-maxskipframes;
 end;
end;


function getframelength(cmd:byte):integer;
{detect length of current frame}
{can use pass 2, pass 3, or pass 4 data}
begin
{
;%11111111,-disp8 = use old frame data
;%111ttttt = skip 32..2 frames
;%110ddddd = slide d+16
;%11010000,frames,-disp16 = repeat block (skips are used as 1 frame)
;%10111111,-disp16 = use old frame data
;%10NNNNNf = keyoff,[freq,]0..30 regs, keyon
;%01111111 = end
;%01111110 = begin
;%01NNNNNf = keyoff,[freq,]0..31 regs
;%00NNNNNf =        [freq,]0..30 regs
}
 case cmd of
  $d0: getframelength:=4;
  $ff: getframelength:=2;
  $bf: getframelength:=3;
  $7f,$7e: getframelength:=1;
  else if cmd>=$c0
       then getframelength:=1
       else getframelength:=1{cmd}+(cmd and 1)*2{freq}+(cmd and $3e){regs};
 end;
end;



procedure readframetfd;
begin
 chip:=0;
 keyoff:=false;
 keyon:=false;
{ 1 }
 if inskipframes<>0
 then dec(inskipframes)
 else
  while(true)do
  begin
   bread;cmd:=b;
   if bye=0 {EOF, b } then break;
   if(b=$ff{end of frame}) then break;
   if(b=$fe{skip N+3 frames}) then
   begin
    bread; {N}
    inskipframes:=b+2;
    break;
   end; {skip N+3 frames}
   case cmd of
    $fa:begin{loopbeg}
         loopbeg:=true;
        end;
    $fb:begin{loopend}
         loopend:=true;{not used}
        end;
    $fc:begin {chip0}
         chip:=0;
        end;
    $fd:begin {chip1}
         chip:=1;
        end;
    $28:
    begin
     bread;
     if((b and 3)=ch123)and(chip=chchip)
     then begin
      if(b and $f0)=0 then keyoff:=true
      else
      if(b and $f0)=$f0 then keyon:=true
      else
      {  - }
      writeln('frame=',frame,' bad key mask!');
     end;
    end;
    $20..$27:
      writeln('frame=',frame,' $20..$27 in stream! ',cmd);
    $29..$2f:
      writeln('frame=',frame,' $29..$2f in stream! ',cmd);
    $b4..$f9:
      writeln('frame=',frame,' $b4..$f9 in stream! ',cmd);
   else (* case *)
    begin
     bread;{cmd=reg, b=value}
     if (reg[chip,cmd]<>b){or((cmd>=$40)and(cmd<=$4f)){tl}
     then begin
      reg[chip,cmd]:=b;
      regchanged[chip,cmd]:=true
     end
     else inc(dups);
    end;
   end; (*case*)
  end;{ 1 }
end; {procedure readframetfd}



procedure writeframepass1;
begin
 {,       ( $ax)}
 howmanyoldregs:=0;
 for i:=0 to 255 do
  if ((i and 3)=ch123)
  and regtowrite[chchip,i]
  then inc(howmanyoldregs);
 {,    ( $ax  )}
 howmanychangedregs:=0;
 for i:=0 to 255 do
  if ((i and 3)=ch123)
  and regchanged[chchip,i]
  then inc(howmanychangedregs);
 {,     }
 {     ,    }
 {,          }
 howmanyinsregs:=0;
 for i:=0 to 255 do
  if ((i and 3)=ch123)
  and regchanged[chchip,i]
and (i>=$50)and(i<=$8f)
  then inc(howmanyinsregs);

 {   howmanyoldregs+NNN() ,
      howmanychangedregs-NNN 
 (   ,      tempo>1).
  howmanyoldregs+NNN   howmanychangedreds-NNN,
   howmanyoldregs+NNN = (howmanyoldregs+howmanychangedregs)/2,
   NNN = (howmanychangedregs-howmanyoldregs)/2.
 NNN   howmanyinsregs,     }
(* if howmanychangedregs{ }<howmanyoldregs
 then howmanyinsregs:=0
 else if ((howmanychangedregs-howmanyoldregs)div 2)<howmanyinsregs
      then begin
       inc(ssgs);
       howmanyinsregs:=(howmanychangedregs-howmanyoldregs)div 2;
      end;(**)
 {,      ,     -
     }

 if loopbeg then howmanyinsregs:=0;

 {       
 (regprepared,    regtowrite)
     regchanged.}
 for i:=0 to 255 do
  if ((i and 3)=ch123)
  and regchanged[chchip,i]
and (i>=$50)and(i<=$8f)
  then begin
    if howmanyinsregs=0 then break;
    dec(howmanyinsregs);{}
   regprepared[chchip,i]:=reg[chchip,i];
   regtowrite[chchip,i]:=true;
   regchanged[chchip,i]:=false;
  end;

 {   (    )
 (regprepared,    regtowrite)
     regtowrite.}

{      ,
 ,    ,
    -}
 if regtowrite[chchip,$a0+ch123]or regtowrite[chchip,$a4+ch123]
 then begin
  regtowrite[chchip,$a0+ch123]:=false;
  regtowrite[chchip,$a4+ch123]:=true;
 end;

{    }
 nregs:=0;
 for i:=0 to 255 do
  if ((i and 3)=ch123)
  and regtowrite[chchip,i]
and (i<>($a4+ch123))
  then inc(nregs);

 regswritten:=0;

 if (nregs=0)and not(keyonprepared or keyoffprepared)
and not(regtowrite[chchip,$a4+ch123]){}
 then inc(outskipframes)
 else begin
  while outskipframes<>0 do writeskipframes;
{  if nregs>15 then begin
   writeln('frame=',frame,' nregs=',nregs,'>15! (insregs=',howmanyinsregs,')');
   for i:=0 to 255 do
    if ((i and 3)=ch123)
     and regtowrite[chchip,i]
     and (i<>($a4+ch123))
    then write(inttohex(i),' ');
   writeln;
  end;{}
  b:=64*ord(keyoffprepared)+64*ord(keyonprepared)+2*nregs+ord(regtowrite[chchip,$a4+ch123]);
  bwrite;
 end;

 if regtowrite[chchip,$a4+ch123]
 then begin
   regtowrite[chchip,$a4+ch123]:=false;{a0+  }
   b:=regprepared[chchip,$a4+ch123];bwrite;inc(regswritten);
   b:=regprepared[chchip,$a0+ch123];bwrite;inc(regswritten);
   inc(freqs);
 end;

 for i:=0 to 255 do
 begin
  if ((i and 3)=ch123)
  and regtowrite[chchip,i]
and (i<>($a4+ch123))
  then begin
   regtowrite[chchip,i]:=false;
   b:=i;bwrite;
   b:=regprepared[chchip,b];bwrite;inc(regswritten);
   inc(noskips);
   if(i>=$40)and(i<=$4f) then inc(tls);
  end;
 end;{  }

 if (regswritten>maxregswritten) then maxregswritten:=regswritten;

 {       
 (regprepared,    regtowrite)
     regchanged.}
 for i:=0 to 255 do
 begin
  if ((i and 3)=ch123)
  and regchanged[chchip,i]
{and not((i>=$50)and(i<=$8f)){  }
  then begin
   regprepared[chchip,i]:=reg[chchip,i];
   regtowrite[chchip,i]:=true;
   regchanged[chchip,i]:=false;
  end;
 end;
 keyonprepared:=keyon;
 keyoffprepared:=keyoff;
 if loopbeg then
 begin
  while outskipframes<>0 do writeskipframes;
  b:=$7e;bwrite;
  loopbeg:=false;
 end;
end; {writeframepass1}





procedure parsechannel;
begin
ch123:=ch mod 3;{   0..2}
chchip:=ch div 3;{   0..1}
inskipframes:=0;
outskipframes:=0;
frame:=0;
regswritten:=0;
 for i:=0 to 255 do
 begin
  reg[0,i]:=-1;
  reg[1,i]:=-1;{-   [chchip,i]}
 end;
 for i:=0 to 255 do
 begin
  regchanged[0,i]:=false;
  regchanged[1,i]:=false;{-   [chchip,i]}
  regtowrite[0,i]:=false;
  regtowrite[1,i]:=false;{-   [chchip,i]}
 end;
key:=false;
loopbeg:=true;
loopend:=false;{not used}

repeat
 readframetfd;
{, :
 1. ;
 2.   topgun   key off.

 if key
 then
  if not keyoff then begin keyon:=false;inc(keydups) end else
 else
  if keyoff then begin keyoff:=false;inc(keydups) end;
 if keyoff then key:=false;
 if keyon then key:=true;}
{no SSG}
 for i:=0 to 15 do regchanged[chchip,i]:=false;
{      ,
 ,   }
 if regchanged[chchip,$a0+ch123]or regchanged[chchip,$a4+ch123]
 then begin
  regchanged[chchip,$a0+ch123]:=true;
  regchanged[chchip,$a4+ch123]:=true;
 end;
 if keyon
 then if keyoff
      then
      else keyoff:=true
 else if keyoff
      then inc(keyoffs)
      else;
 inc(keyons,ord(keyon));
 writeframepass1;
 inc(frame);
{ if(frame=32768)then writeln('frames>32767!'); {  }
until bye=0;

writeframepass1;
while outskipframes<>0 do writeskipframes;
 b:=$7f;bwrite;
end; {procedure parsechannel}



procedure readuntil0;
begin
repeat
 blockread(fin,b,1);
 inc(tfmdinfosize);
until b=0;
end;


procedure channelfile(infilename:string;outfilename:string);
begin
{pass 1}
 totalread:=0;totalwrite:=0;
 assign(fin,infilename);
 reset(fin,1);
 blockread(fin,buf4,4);
 tfmd:=(buf4[0]='T')and(buf4[1]='F')and(buf4[2]='M')and(buf4[3]='D');
 tfmdinfosize:=3 {i.e. three zeros};
 if not tfmd
 then reset(fin,1)
 else begin
  readuntil0;
  readuntil0;
  readuntil0;
 end;

 readpos:=bufsz;
 realbufsz:=1;{?}
 bye:=-1;
 assign(fout,'temp'{outfilename{});
 rewrite(fout,1);
 writepos:=0;

 parsechannel;

  close(fin);
 blockwrite(fout,wrbuf,writepos);
 totalwrite:=totalwrite+writepos;
  close(fout);

 write('file=',outfilename);
 write(', IN size=',totalread);
 write(', OUT size=',totalwrite);


{pass 2}
{find slides}
 totalread:=0;totalwrite:=0;
 assign(fin,'temp');
 reset(fin,1);
 readpos:=bufsz;
 realbufsz:=1;{?}
 bye:=-1;
 assign(fout,outfilename);
 rewrite(fout,1);
 writepos:=0;
 oldh:=-999;oldl:=-999;

 repeat
   bread;
   if bye=0 {EOF, b } then break;
   cmd:=b;
   case cmd of
   $01{freq}:begin
    bread;h:=b;
    bread;l:=b;
    if (oldh=h)
    then
     if (byte((l-oldl)+16)<32)
     then begin{2*economy on slide}
      if l=oldl then write('=');
      b:=$c0+byte((l-oldl)+16);bwrite;
      inc(economy2,2);
      inc(slideeconomy,2);
      inc(slides);
     end
     else begin{lowfreq - no economy}
      b:=cmd;bwrite;
      b:=h;bwrite;
      b:=l;bwrite;
      inc(lowfreqs);
     end
    else begin{no economy}
     b:=cmd;bwrite;
     b:=h;bwrite;
     b:=l;bwrite;
    end;
   end;{cmd=$01}
   else begin
    bwrite; {skip is one-byte command, another ones may be longer}
    if(cmd<$bf{not skip})and(cmd<>$7e)and(cmd<>$7f)
    then begin
     if (cmd and 1)<>0{freq used}
     then begin
      bread;h:=b;bwrite;{h}
      bread;l:=b;bwrite;{l}
     end;
     if ((cmd div 2) and $1f)>0 then
      for i:=1 to ((cmd div 2) and $1f) do
      begin
       bread;bwrite;{reg}
       bread;bwrite;{value}
      end;
    end;{not skip}
   end;{case else}
   end;{case}
   oldh:=h;
   oldl:=l;
 until bye=0;

  close(fin);
 Erase(fin);
 blockwrite(fout,wrbuf,writepos);
 totalwrite:=totalwrite+writepos;
  close(fout);

 write(', ',totalwrite);
(**)


{pass 3}
{LZ
;%11010000,frames,-disp16 = repeat block (skips are used as 1 frame)}
 totalread:=0;totalwrite:=0;
 assign(fin,outfilename);
 reset(fin,1);
 realbufsz:=filesize(fin);
 blockread(fin,indata,realbufsz);
{ outdata:=indata;}
 close(fin);
 readpos:=0;writepos:=0;

 for i:=0 to newaddrsz-1 do
  newaddr[i]:=-1;

 while (readpos<realbufsz) do begin
  newaddr[readpos]:=writepos;
  {find longest dublicate}
  maxlen:=0;
  maxframes:=0;
  if (writepos>0)
  then begin
   for j1:=readpos-1 downto 0 do
   if newaddr[j1]<>-1 {     ,      LZ}
   then begin
    j:=newaddr[j1];
    k:=0;
    while (k < (writepos-j){ })
      and (k < (realbufsz-readpos){  eof })
      and (outdata[j+k] = indata[readpos+k])
       do inc(k);
    {j+k points to first unequal element}
    if (k>maxlen) then begin
     maxlen:=k;
     disp:=writepos-j;
    end;{if k>maxlen}
   end;{for j1}
   if maxlen>255 then maxlen:=255;
   {truncate maxlen to integer number of frames}
   if maxlen>0
   then begin
    k:=0;
    j:=writepos-disp;
    maxframes:=-1;
    while k<=maxlen do
    begin
     if k<maxlen then begin
      if indata[readpos+k]<>outdata[j+k] then write(maxlen,'%');
      if(indata[readpos+k]=$d0)then begin
       write(readpos,'!');
      end;
      if(outdata[writepos-disp+k]=$d0)then write(writepos,'@');
     end;
     curframelength:=getframelength(indata[readpos+k]);
     inc(k,curframelength);
     inc(maxframes);
    end;
    maxlen:=k-curframelength;
   end; {if maxlen>0}
  end;{if writepos>0}

  if (maxlen>4)and(maxframes>=15)
  then begin
   b:=$d0;arraywrite;
   b:=maxframes;arraywrite;
   b:=(65536-(disp+4))shr 8;arraywrite;
   b:=65536-(disp+4);arraywrite;
   inc(economy3,maxlen-4);
   inc(readpos,maxlen);
  end
  else begin {copy from readpos to writepos}
   if maxframes=0 then maxframes:=1;
   for i:=1 to maxframes do begin
    cmd:=indata[readpos];
    curframelength:=getframelength(cmd);
    case cmd of
    $d0:begin{bug}
      write(readpos,'*');
      readln;
      inc(readpos);arraywrite;
    end;
    $bf:begin{long disp}
{      write(readpos,'$');}
      inc(readpos);
      h:=indata[readpos];inc(readpos);
      l:=indata[readpos];inc(readpos);
      where:=(h*256+l)-65536+readpos;
      wherelength:=getframelength(indata[where]);
      {find the same in outdata}
      dublicateframefound:=false;
      for j:=writepos-1 downto 0 do begin
       found:=true;
       for k:=0 to wherelength-1 do
        if (outdata[j+k]<>indata[where+k])then begin
         found:=false;
         break;{for k}
        end;
       if found then begin
        disp:=writepos-j;
        dublicateframefound:=true;
        break;{for j}
       end;
      end;
      if(dublicateframefound=false)then write(readpos,'B');
      b:=$bf;arraywrite;
      b:=(65536-(disp+3))shr 8;arraywrite;
      b:=65536-(disp+3);arraywrite;
    end;
    $ff:begin{short disp}
{      write(readpos,'#');}
      inc(readpos);
      h:=$ff;
      l:=indata[readpos];inc(readpos);
      where:=(h*256+l)-65536+readpos;
      wherelength:=getframelength(indata[where]);
      {find the same in outdata}
      dublicateframefound:=false;
      for j:=writepos-1 downto 0 do begin
       found:=true;
       for k:=0 to wherelength-1 do
        if (outdata[j+k]<>indata[where+k])then begin
         found:=false;
         break;{for k}
        end;
       if found then begin
        disp:=writepos-j;
        dublicateframefound:=true;
        break;{for j}
       end;
      end;
      if(dublicateframefound=false)then begin
       write(readpos,'b');
      end;
      b:=$ff;arraywrite;
      b:=65536-(disp+2);arraywrite;
    end;
    else
     for j:=1 to curframelength do
     begin
      b:=indata[readpos];inc(readpos);arraywrite;
     end;
    end; {case}
   end;
  end;

 end; {while (readpos<realbufsz)}

 assign(fout,outfilename);
 rewrite(fout,1);
 blockwrite(fout,outdata,writepos);
 totalwrite:=totalwrite+writepos;
 close(fout);
 write(', ',totalwrite);
(**)


{pass 4}
{find dublicate frames}
 totalread:=0;totalwrite:=0;
 assign(fin,outfilename);
 reset(fin,1);
 realbufsz:=filesize(fin);
 blockread(fin,indata,realbufsz);
 close(fin);
 readpos:=0;writepos:=0;

 for i:=0 to newaddrsz-1 do
  newaddr[i]:=-1;

 while (readpos<realbufsz) do begin
  newaddr[readpos]:=writepos;
  cmd:=indata[readpos];
  curframelength:=getframelength(cmd);

  dublicateframefound:=false;
  {if curframelength>=3, then search a dublicate frame}
  if (curframelength>=3) and (writepos>0) and (cmd<>$d0)
  then begin
   for j1:=readpos-1 downto 0 do
   if newaddr[j1]<>-1 {     ,      LZ}
   then begin
    j:=newaddr[j1];
    found:=true;
    for k:=0 to curframelength-1 do
     if (outdata[j+k]<>indata[readpos+k])then begin
      found:=false;
      break;{for k}
     end;
    if found then begin
     disp:=writepos-j;
     dublicateframefound:=true;
     break;{for j}
    end;
   end;
  end; {curframelength>=3}

  if (curframelength=3) and ((disp+2)>256) then dublicateframefound:=false;

  {if dublicate frame is found, then send #bf,-disp16 or #ff,-disp8}
  if dublicateframefound
  then begin
   if (disp+2)>256
   then begin{long disp}
    b:=$bf;arraywrite;
    b:=(65536-(disp+3))shr 8;arraywrite;
    b:=65536-(disp+3);arraywrite;
    inc(economy4,curframelength-3);
   end
   else begin{short disp}
    b:=$ff;arraywrite;
    b:=65536-(disp+2);arraywrite;
    inc(economy4,curframelength-2);
   end;
   inc(readpos,curframelength);
  end {dublicateframefound}
  else begin {copy the frame from readpos to writepos}
   if indata[readpos]=$d0
   then begin
    inc(readpos);
    maxframes:=indata[readpos];inc(readpos);
    h:=indata[readpos];inc(readpos);
    l:=indata[readpos];inc(readpos);
    disp:=65536-(h*256+l);
    if (newaddr[readpos-disp]=-1) then write(writepos,'!');
    disp:=writepos-newaddr[readpos-disp];
    b:=$d0;arraywrite;
    b:=maxframes;arraywrite;
    b:=(65536-(disp+4))shr 8;arraywrite;
    b:=65536-(disp+4);arraywrite;
   end
   else
    for i:=1 to curframelength do begin
     b:=indata[readpos];inc(readpos);arraywrite;
    end;
  end;

 end; {while (readpos<realbufsz)}

 assign(fout,outfilename);
 rewrite(fout,1);
 blockwrite(fout,outdata,writepos);
 totalwrite:=totalwrite+writepos;
 close(fout);
 write(', ',totalwrite);
(**)


 writeln;
 totaltotalwrite:=totaltotalwrite+totalwrite;
 chsize[ch]:=totalwrite;

end;


begin
  { TODO -oUser -cConsole Main : Insert code here }
{ clrscr;{}
 dups:=0;
 keyoffs:=0;keyons:=0;keydups:=0;
 keyofffreqs:=0;
 noskips:=0;freqs:=0;tls:=0;slides:=0;lowfreqs:=0;
 maxregswritten:=0;newmaxregswritten:=0;
 economy2:=0;slideeconomy:=0;lowfreqeconomy:=0;notefreqskipeconomy:=0;
 economy3:=0;
 economy4:=0;
 if paramcount<1
 then filename:='tg2l2.tfd'
 else filename:=ParamStr(1);
 assign(fin,filename);
 reset(fin,1);
 if(filesize(fin)=0)then Halt(1);
 writeln('============================= TFM compiler v1.1 ===============================');
 writeln('input file=',filename);
 totaltotalwrite:=0;
 ch:=0;{   0..5}
 channelfile(filename,'temptfm0');
 ch:=1;{   0..5}
 channelfile(filename,'temptfm1');
 ch:=2;{   0..5}
 channelfile(filename,'temptfm2');
 ch:=3;{   0..5}
 channelfile(filename,'temptfm3');
 ch:=4;{   0..5}
 channelfile(filename,'temptfm4');
 ch:=5;{   0..5}
 channelfile(filename,'temptfm5');
 writeln('dups killed=',dups);
 writeln('economy on pass 2=',economy2,', pass 3=',economy3,', pass 4=',economy4);
 writeln('keyoffs=',keyoffs,', keyons=',keyons,', keydups killed=',keydups);
 writeln('tls=',tls);
 writeln('freqs=',freqs,': slides=',slides,', other lowfreqs=',lowfreqs);
 writeln('other registers=',noskips-tls);
 writeln('maxregswritten=',maxregswritten);

 savefilename:=filename;
 j:=0;
 for i:=1 to length(savefilename) do
  if savefilename[i]='.' then j:=i;
 if (j>0) and (j>length(savefilename)-4) then delete(savefilename,j,4);
 savefilename:=savefilename+'.tfc';

 assign(fout,savefilename);
 rewrite(fout,1);
 totalwrite:=0;
 writepos:=0;
 b:=ord('T');bwrite;
 b:=ord('F');bwrite;
 b:=ord('M');bwrite;
 b:=ord('c');bwrite;
 b:=ord('o');bwrite;
 b:=ord('m');bwrite;
 b:=ord('1');bwrite;
 b:=ord('.');bwrite;
 b:=ord('1');bwrite;
 b:=50;bwrite;{Hz}
 chaddr:=10+6*2+6*2+tfmdinfosize;
 for ch:=0 to 5 do
 begin {FM}
  b:=chaddr;bwrite;
  b:=chaddr shr 8;bwrite;
  chaddr:=chaddr+chsize[ch];
 end;
 for ch:=0 to 5 do
 begin {SSG}
  b:=0;bwrite;
  b:=0;bwrite;
 end;

 if tfmd
 then begin
  assign(fin,filename);
  reset(fin,1);
  blockread(fin,buf4,4);
  for i:=1 to tfmdinfosize do
  begin
   blockread(fin,b,1);
   bwrite;
  end;
  close(fin);
 end
 else begin {not tfmd}
  b:=0;bwrite;
  b:=0;bwrite;
  b:=0;bwrite;
 end;

 for ch:=0 to 5 do
 begin
  loadfilename:='temptfm'+chr(ch+$30);
  assign(fin,loadfilename);
  reset(fin,1);
  readpos:=bufsz;
  realbufsz:=1;{?}
  bye:=-1;
  for i:=1 to chsize[ch] do
  begin
   bread;
   bwrite;
  end;
  close(fin);
  Erase(fin);
 end;
 blockwrite(fout,wrbuf,writepos);
 totalwrite:=totalwrite+writepos;
 close(fout);
 writeln('total bytes=',totalwrite);

end.