// gym2tfm.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <windows.h>
#include <stdlib.h>

unsigned char *gymData;
int gymSize;
unsigned char *oldData,*tfmData;

#define TFM_INT		0xff
#define TFM_CHIP0	0xfc
#define TFM_CHIP1	0xfd
#define TFM_END		0xfb


int regState1[256*2];
int regState2[256*2];
int slotState[4*2];

struct {
	unsigned char chanVol[4];
	short int     chanDiv[4];	
	unsigned short int noiseLFSR;
	unsigned short int noiseTBits;
	char latchedChan;
	char latchedType;//0 tone(noise) 1 volume
} PSG;



void out_ay(int &tPtr,unsigned char reg,unsigned char val)
{
	//return;
	if(regState1[reg]!=val)
	{
		regState1[reg]=val;
		regState2[reg]=val;
		tfmData[tPtr+0]=reg;
		tfmData[tPtr+1]=val;
		tPtr+=2;
	}
}


void out_fm(int &tPtr,int chipSel,int reg,unsigned char val)
{
	//return;
	
	float freq;
	int ifreq,block;
	
	regState1[chipSel*256+reg]=val;
	regState2[chipSel*256+reg]=val;
	
	if(reg!=0xa4&&reg!=0xa5&&reg!=0xa6&&reg!=0xac&&reg!=0xad&&reg!=0xae)
	{
		if(reg!=0xa0&&reg!=0xa1&&reg!=0xa2&&reg!=0xa8&&reg!=0xa9&&reg!=0xaa)
		{
			tfmData[tPtr+0]=reg;
			tfmData[tPtr+1]=val;
			tPtr+=2;
		}
		else
		{
			//   ,  
			switch(reg)
			{
			case 0xa0:
				tfmData[tPtr+0]=0xa4;
				tfmData[tPtr+1]=regState1[chipSel*256+0xa4];
				break;
			case 0xa1:
				tfmData[tPtr+0]=0xa5;
				tfmData[tPtr+1]=regState1[chipSel*256+0xa5];
				break;
			case 0xa2:
				tfmData[tPtr+0]=0xa6;
				tfmData[tPtr+1]=regState1[chipSel*256+0xa6];
				break;
			case 0xa8:
				tfmData[tPtr+0]=0xac;
				tfmData[tPtr+1]=regState1[chipSel*256+0xac];
				break;
			case 0xa9:
				tfmData[tPtr+0]=0xad;
				tfmData[tPtr+1]=regState1[chipSel*256+0xad];
				break;
			case 0xaa:
				tfmData[tPtr+0]=0xae;
				tfmData[tPtr+1]=regState1[chipSel*256+0xae];
				break;
			}
			tfmData[tPtr+2]=reg;
			tfmData[tPtr+3]=val;
			
			//   FM-
			
			ifreq=(tfmData[tPtr+1]<<8)+tfmData[tPtr+3];
			
			block=(ifreq>>11)&7;
			freq=float(ifreq&0x7ff);
			freq=freq*17.0f/16.0f;//1.065513f;
			ifreq=int(freq);
			if(ifreq>=2048) { ifreq/=2; block++; }
			ifreq=(block<<11)+ifreq;
			
			tfmData[tPtr+1]=(ifreq>>8)&0xff;
			tfmData[tPtr+3]=ifreq&0xff;
			
			tPtr+=4;
		}
	}
}



void psg_out_port(unsigned char val)
{
	int chan,div;
	
	if(val&128)
	{
		chan=(val>>5)&3;
		div=(PSG.chanDiv[chan]&0xfff0)|(val&15);
		
		PSG.latchedChan=chan;
		PSG.latchedType=val&16;
	}
	else
	{
		chan=PSG.latchedChan;
		div=(PSG.chanDiv[chan]&15)|((val&63)<<4);
	}
	
	if(PSG.latchedType)
	{
		PSG.chanVol[chan]=(PSG.chanVol[chan]&16)|(val&15);
	}
	else
	{
		PSG.chanDiv[chan]=div;
		if(chan==3)
		{
			if(((div>>2)&1)) PSG.noiseTBits=9; else PSG.noiseTBits=1;
			PSG.noiseLFSR=0x8000;
		}
	}
}



int find_next_int(int gPtr,int tSize)
{
	while(gPtr<tSize)
	{
		switch(oldData[gPtr])
		{
			//case 0xfe:
			//	return gPtr+2;
		case TFM_INT:
		case TFM_END:
			return gPtr+1;
		case TFM_CHIP0:
		case TFM_CHIP1:
			gPtr++;
			break;
		default:
			gPtr+=2;
		}
	}
	return gPtr;
}



int main(int argc, char* argv[])
{
	int gPtr,tPtr,chipSel=0,aa,tfmSize,frameEnd;
	int noiseDiv;
	unsigned char cmd,reg,val;
	
	printf("gym2tfm v0.1\n\n");
	
	
	FILE *file;
	
	if (argc<1 || argv[1]==0) exit(-1);
	file=fopen(argv[1],"rb");
	
	//file=fopen("exranza.gym","rb");
	//file=fopen("sor_title.gym","rb");
	//file=fopen("comix.gym","rb");
	//file=fopen("batman_lv1.gym","rb");
	//file=fopen("sonic3.gym","rb");
	//file=fopen("fireshark.gym","rb");
	
	if(!file)
	{
		printf("Error: no such file.\n");
		return 0;
	}
	fseek(file,0,SEEK_END);
	gymSize=ftell(file);
	fseek(file,0,SEEK_SET);
	gymData=(unsigned char*)malloc(gymSize);
	tfmData=(unsigned char*)malloc(gymSize);
	fread(gymData,gymSize,1,file);
	fclose(file);
	
	printf("GYM size: %i\n",gymSize);
	
	gPtr=256;
	tPtr=0;
	
	for(aa=0;aa<256*2;aa++) regState1[aa]=-1;
	for(aa=0;aa<256*2;aa++) regState2[aa]=-1;
	
	while(gPtr<gymSize) //     
	{
		if(gymData[gPtr]==0&&gymData[gPtr+1]==0) gPtr++; else break;
	}
	
	memset(&PSG,0,sizeof(PSG));
	/*//   
	chipSel=1;
	tfmData[tPtr]=TFM_CHIP1;
	tPtr++;
	out_ay(tPtr,7,255^16);
	
	  chipSel=0;
	  tfmData[tPtr]=TFM_CHIP0;
	  tPtr++;
	  out_ay(tPtr,7,255^7);
	  out_ay(tPtr,8,0);
	  out_ay(tPtr,9,0);
	  out_ay(tPtr,10,0);
	*/
	
	while(gPtr<gymSize)
	{
		cmd=gymData[gPtr];
		
		if(cmd==0) //
		{
			
			//   PSG     AY
			
			if(chipSel!=0)
			{
				tfmData[tPtr]=TFM_CHIP0;
				tPtr++;
			}
			
			out_ay(tPtr,0,PSG.chanDiv[0]&255);
			out_ay(tPtr,1,PSG.chanDiv[0]>>8);
			out_ay(tPtr,2,PSG.chanDiv[1]&255);
			out_ay(tPtr,3,PSG.chanDiv[1]>>8);
			out_ay(tPtr,4,PSG.chanDiv[2]&255);
			out_ay(tPtr,5,PSG.chanDiv[2]>>8);
			out_ay(tPtr,8,15-(PSG.chanVol[0]&15));
			out_ay(tPtr,9,15-(PSG.chanVol[1]&15));
			out_ay(tPtr,10,15-(PSG.chanVol[2]&15));
			
			tfmData[tPtr]=TFM_CHIP1;
			tPtr++;
			switch(PSG.chanDiv[3]&3)
			{
			case 0: noiseDiv=0; break;
			case 1: noiseDiv=4; break;
			case 2: noiseDiv=8; break;
			case 3:
				noiseDiv=PSG.chanDiv[2]>>1;
				if(noiseDiv>63) noiseDiv=63;
				break;
			}
			out_ay(tPtr,6,noiseDiv);
			out_ay(tPtr,9,15-PSG.chanVol[3]&15);
			
			//////////////////////////////
			
			tfmData[tPtr]=TFM_INT;
			tPtr++;
			gPtr++;
			chipSel=0;
			continue;
		}
		
		if(cmd==3) //PSG
		{
			psg_out_port(gymData[gPtr+1]);
			gPtr+=2;
			continue;
		}
		
		if(cmd==1||cmd==2) //YM
		{
			if(chipSel==0 && cmd!=1) //    -      
			{
				chipSel=1;
				tfmData[tPtr]=TFM_CHIP1;
				tPtr++;
			}
			else
			{
				if(chipSel==1 && cmd!=2)
				{
					chipSel=0;
					tfmData[tPtr]=TFM_CHIP0;
					tPtr++;
				}
			}
			
			reg=gymData[gPtr+1];
			val=gymData[gPtr+2];
			
			if(reg==0x28)
			{
				if(val&4)
				{
					//     -  
					//  &(255^4)
					//     -   
					if(chipSel==1)
					{
						out_fm(tPtr,1,0x28,val&(255^4));
					}
					else
					{
						tfmData[tPtr]=TFM_CHIP1;
						tPtr++;
						out_fm(tPtr,1,0x28,val&(255^4));
						tfmData[tPtr]=TFM_CHIP0;
						tPtr++;
					}
				}
				else
				{
					//     -  
					// 
					//     -   
					if(chipSel==0)
					{
						out_fm(tPtr,0,0x28,val);
					}
					else
					{
						tfmData[tPtr]=TFM_CHIP0;
						tPtr++;
						out_fm(tPtr,0,0x28,val);
						tfmData[tPtr]=TFM_CHIP1;
						tPtr++;
					}
				}
			}
			else
			{
				if(reg>=0x30&&reg<0xb4) out_fm(tPtr,chipSel,reg,val);
			}
			
			gPtr+=3;
			continue;
		}
		printf("Error: unknown code %i in stream.\n",cmd);
		break;
	}
	
	tfmData[tPtr]=TFM_END;
	tPtr++;
	
	free(gymData);
	
	tfmSize=tPtr;
	printf("Pure TFM size: %i\n",tfmSize);
	
	//    
	oldData=tfmData;
	tfmData=(unsigned char*)malloc(gymSize);
	tPtr=0;
	gPtr=0;
	
	
	while(gPtr<tfmSize)
	{
		frameEnd=find_next_int(gPtr,tfmSize);
		
		tfmData[tPtr]=TFM_INT; tPtr++;
		for (int chS=0; chS<2; chS++)
		{
			if (chS==1) tfmData[tPtr++]=TFM_CHIP1;
			chipSel=0;
			aa=gPtr;
			while(aa<frameEnd)
			{
				switch(oldData[aa])
				{
				case TFM_INT:
				case TFM_END:
					aa++;
					continue;
				case TFM_CHIP0:
					chipSel=0;
					aa++;
					continue;
				case TFM_CHIP1:
					chipSel=1;
					aa++;
					continue;
				}
				if(chipSel==chS)
				{
					tfmData[tPtr]=oldData[aa];   tPtr++;
					tfmData[tPtr]=oldData[aa+1]; tPtr++;
				}
				aa+=2;
			}
		}
		gPtr=frameEnd;
	}
	
	tfmSize=tPtr;
	printf("Sorted chips TFM size: %i\n",tfmSize);
	free(oldData);
	
	//        
	//    
	//*
#define FILTER
#ifdef FILTER
	oldData=tfmData;
	tfmData=(unsigned char*)malloc(gymSize);
	tPtr=0;
	gPtr=0;
	
	for(aa=0;aa<256*2;aa++) regState2[aa]=-1;
	for(aa=0;aa<4*2;aa++) slotState[aa]=-1;

	while(gPtr<tfmSize)
	{
		frameEnd=find_next_int(gPtr,tfmSize);
		
		// 
		
		tfmData[tPtr]=TFM_INT; tPtr++;
		
		for(aa=0;aa<256*2;aa++) regState1[aa]=-1;
		
		// ,     2*256
		
		chipSel=0;
		aa=gPtr;
		while(aa<frameEnd)
		{
			switch(oldData[aa])
			{
			case TFM_INT:
			case TFM_END:
				aa++;
				continue;
			case TFM_CHIP0:
				chipSel=0;
				aa++;
				continue;
			case TFM_CHIP1:
				chipSel=256;
				aa++;
				continue;
			}
			regState1[(int)oldData[aa]+chipSel]=(int)oldData[aa+1];
			aa+=2;
		}

		regState1[0x28]=-1;
		regState1[0x28+256]=-1;
		//      (  28)

		// 0x28   (  )
		for (int chS=0; chS<2; chS++)
		{
			chipSel=0;
			aa=gPtr;
			int firstData=0;
			if (chS==1) tfmData[tPtr]=TFM_CHIP1;
			else tPtr--;

			while(aa<frameEnd)
			{
				switch(oldData[aa])
				{
				case TFM_INT:
					aa++;
					continue;
				case TFM_END:
					break;
				case TFM_CHIP0:
					chipSel=0;
					aa++;
					continue;
				case TFM_CHIP1:
					chipSel=1;
					aa++;
					continue;
				}
			
				if(chS==chipSel && oldData[aa]==0x28)
				{
					int ta=oldData[aa+1]&255;
/*
					int tb=ta&0xf0;
					if (slotState[chS*4+ta&3]!=tb)
					{
						slotState[chS*4+ta&3]=tb;
*/
						if (!firstData) {firstData=1; tPtr++;}
						tfmData[tPtr++]=0x28;
						tfmData[tPtr++]=ta;
/*
					}
					else
					{
//						if (!firstData) {firstData=1; tPtr++;}
//						tfmData[tPtr++]=0x29;
//						tfmData[tPtr++]=ta;
					}
*/
				}
				aa+=2;
			}
		
			for(aa=255;aa>=0;aa--)
			{
				if (regState1[aa+chS*256]!=regState2[aa+chS*256]
				&&regState1[aa+chS*256]>=0) //if there are any changes
				{
					if ((aa&0xf4)==0xa0) //if it LOW tone reg - send HI then LOW
					{
						if (!firstData) {firstData=1; tPtr++;}
						int aa2=(aa&0x0b)|0xa4;
						tfmData[tPtr++]=aa2; //hi
						tfmData[tPtr++]=regState1[aa2+chS*256];
						tfmData[tPtr++]=aa; //low
						tfmData[tPtr++]=regState1[aa+chS*256];
					}
					else if ((aa&0xf0)!=0xa0)
					{
						if (!firstData) {firstData=1; tPtr++;}
						tfmData[tPtr++]=aa;
						tfmData[tPtr++]=regState1[aa+chS*256];
					}
					regState2[aa+chS*256]=regState1[aa+chS*256]; //copy changes to "current regs"
				}
			}
			if (!firstData && chS==0) tPtr++; //if it's an empty or chip1 only int
		}
		gPtr=frameEnd;
	}
	
	tfmSize=tPtr;
	printf("Last writes TFM size: %i\n",tfmSize);
	free(oldData);
	
#endif
	tfmData[tPtr]=TFM_END; tPtr++;
	/*
	printf("\n\nwrites log:\n");
	aa=0;
	int intCount=0,lineCount=0;
	
	while(aa<tfmSize)
	{
		switch(tfmData[aa])
		{
		case TFM_INT:
			printf("\n\nint: %i Chip0:\n",intCount);
			intCount++;
			lineCount=0;
			aa++;
			break;
		case TFM_CHIP0:
			printf("\nChip0:\n");
			lineCount=0;
			aa++;
			break;
		case TFM_CHIP1:
			printf("\nChip1:\n");
			lineCount=0;
			aa++;
			break;
		default:
			printf("[%2.2x]=%2.2x ",tfmData[aa],tfmData[aa+1]);
			lineCount++;
			if(lineCount>=8)
			{
				printf("\n");
				lineCount=0;
			}
			aa+=2;
		}
	}
	*/
	file=fopen("out.tfm","wb");
	if(file)
	{
		fwrite(tfmData,tfmSize,1,file);
		//fwrite(tfmData,35000,1,file);
		fclose(file);
	}
	
	free(tfmData);
	
	return 0;
}

