struct {
	unsigned char *data;
	void *chip0;
	void *chip1;
	bool play;
	int size;
	int rate;
	int scount;
	int ptr;
	int chipsel;
	int intcount;
	int loop;
	int frames;
} TFM;



void tfm_write(int chip,int reg,unsigned char val)
{
	switch(chip)
	{
	case 0:
		YM2203Write(TFM.chip0,0,reg);
		YM2203Write(TFM.chip0,1,val);
		break;
	case 1:
		YM2203Write(TFM.chip1,0,reg);
		YM2203Write(TFM.chip1,1,val);
		break;
	}
}



void tfm_frame(void)
{
	int val;
	
	if(!TFM.play) return;
	
	TFM.frames++;
	
	if(TFM.intcount>0)
	{
		TFM.intcount--;
		return;
	}
	
	while(1)
	{
		val=TFM.data[TFM.ptr++];
		
		switch(val)
		{
		case 0xff://  
			TFM.chipsel=0;
			return;
			
		case 0xfe://  
			TFM.chipsel=0;
			TFM.intcount=TFM.data[TFM.ptr++]+2;
			return;
			
		case 0xfc://  
			TFM.chipsel=0;
			break;
			
		case 0xfd://  
			TFM.chipsel=1;
			break;
			
		case 0xfb:// 
			printf("End of track, %i frames processed\n",TFM.frames);
			TFM.frames=0;
			if(TFM.loop>=0)
			{
				TFM.ptr=TFM.loop;
				printf("Jump to loop point (%i)\n",TFM.loop);
			}
			else
			{
				TFM.play=false;
				return;
			}
			break;
			
		case 0xfa:// 
			TFM.loop=TFM.ptr-1;
			printf("Loop point at %i\n",TFM.loop);
			break;
			
		default:
			tfm_write(TFM.chipsel,val,TFM.data[TFM.ptr++]);
		}
	}
}



inline void tfm_render(short int *buf,int size)
{
	memset(buf,0,size*sizeof(short int));
	YM2203UpdateOne(TFM.chip0,buf,size);
	YM2203UpdateOne(TFM.chip1,buf,size);
}



inline void tfm_player_render(short int *buf,int size)
{
    int frameLen;
	
    frameLen=TFM.rate/50;
	
    if(TFM.scount+size<frameLen)
    {
        tfm_render(buf,size);
        TFM.scount+=size;
    }
    else
    {
        tfm_render(buf,frameLen-TFM.scount);
        buf+=(frameLen-TFM.scount);
        size-=(frameLen-TFM.scount);
        TFM.scount=0;
        tfm_frame();
		
        while(1)
        {
            if(size<frameLen)
            {
                TFM.scount=size;
                tfm_render(buf,size);
                break;
            }
            else
            {
                tfm_render(buf,frameLen);
                tfm_frame();
				
                buf+=frameLen;
                size-=frameLen;
            }
        }
    }
}



bool tfm_open(const char *filename,int clock,int rate)
{
	FILE *file;
	
	file=fopen(filename,"rb");
	if(!file) return false;
	
	fseek(file,0,SEEK_END);
	TFM.size=ftell(file);
	fseek(file,0,SEEK_SET);
	TFM.data=(unsigned char*)malloc(TFM.size);
	fread(TFM.data,TFM.size,1,file);
	fclose(file);
	
	TFM.rate=rate;
	TFM.scount=0;
	TFM.ptr=0;
	TFM.chipsel=0;
	TFM.intcount=0;
	TFM.loop=-1;
	TFM.play=true;
	TFM.frames=0;
	TFM.chip0=YM2203Init(clock,rate);
	TFM.chip1=YM2203Init(clock,rate);
	
	if((TFM.data[0]='T')
	&&(TFM.data[1]='F')
	&&(TFM.data[2]='M')
	&&(TFM.data[3]='D'))
	{
		TFM.ptr=4;
		while(TFM.data[TFM.ptr])TFM.ptr++;
		TFM.ptr++;
		while(TFM.data[TFM.ptr])TFM.ptr++;
		TFM.ptr++;
		while(TFM.data[TFM.ptr])TFM.ptr++;
		TFM.ptr++;
	}

	if(!TFM.chip0||!TFM.chip1)
	{
		free(TFM.data);
		return false;
	}
	
	YM2203ResetChip(TFM.chip0);
	YM2203ResetChip(TFM.chip1);
	tfm_write(0,0x27,0);
	tfm_write(1,0x27,0);
	
	return true;
}



void tfm_close(void)
{
	YM2203Shutdown(TFM.chip0);
	YM2203Shutdown(TFM.chip1);
	free(TFM.data);
}



bool tfm_isplay(void)
{
	return TFM.play;
}