// vgmplay.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#pragma comment(lib,"Winmm.lib")

#include <windows.h>
#include <mmsystem.h>
#include <stdlib.h>
#include <conio.h>

#include "Ym2203_Emu.h"
#include "tfmplay.h"
#include "waverec.h"
#include "waveout.h"




int main(int argc, char* argv[])
{
	const int rate=44100;
	const int clock=3500000;
	
	printf("TFMPLAY v0.3 : YM2203 emulation test\n\n");
	
	WAVF.write=false;
	
	if(argc<2)
	{
		printf("USAGE: tfmplay.exe filename.tfd (for play only)\n");
		printf("       tfmplay.exe filename.tfd filename.wav (for write to wav)\n");
		return 0;
	}
	
	if(tfm_open(argv[1],clock,rate))
	{
		if(argc==3) WAVF.write=wave_open(argv[2],rate);
		
		if(waveout_init(NULL,rate,4096,4))//4096= , 4=- 
		{
			printf("Press any key to stop\n\n");
			
			while(tfm_isplay()&&!kbhit()) Sleep(100);
			
			waveout_shut();
		}
		tfm_close();
		
		if(WAVF.write) wave_close();
	}
	else
	{
		printf("ERR: Can't open file '%s'\n",argv[1]);
	}
	
	return 0;
}

